#define _CRT_SECURE_NO_WARNINGS
#define _USE_MATH_DEFINES
#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <cmath>
#include <limits.h>
#include <queue>
#include <stack>
#include <deque>
#include <set>
#include <map>
#include <hash_set>
#include <hash_map>
#include <utility>
#include <stdio.h>
#include <time.h>
using namespace std;

#define EPS 1E-7
#define MOD 1000000007
#define mp make_pair

long long binpow(long long a, long long p){
	if(!p)return 1;
	if(p%2)return a*binpow(a,p-1);
	long long t = binpow(a,p/2);
	return t*t;
}

long long inv(long long w){
	return binpow(w, MOD-2);
}


long long f(long long pos, long long put){
	if(!pos)return 1;
	long long n = pos + put;
	long long k = put;
	long long ans = 1;

	for(long long i = 0; i < k; ++i){
		ans *= (n-i);
		ans%=MOD;
	}
	for(long long i = 2; i<=k; ++i){
		ans *= inv(i);
		ans%=MOD;
	}
	return ans;
}

int main(){
	freopen("input.txt", "r", stdin); freopen("output.txt", "w", stdout);

	long long n,d,x;
	while(cin>>n>>d>>x, n>0){
		x--;
		if(!x){
			puts("0");
			continue;
		}
		vector<vector<long long>>dp(2020, vector<long long>(2020));
		for(int i=0; i<=x; ++i){
			dp[i][1] = 1;
		}

		for(int i=1; i<=n; ++i){
			for(int j=2; j<=min((long long)i,d); ++j){
				for(int k=1; k <= min((long long)i - j + 1, x); ++k){
					dp[i][j] += dp[i-k][j-1];
					dp[i][j] %= MOD;
				}
			}
		}

		long long ans = 0;
		for(int i=1; i<=n; ++i){
			ans += dp[n][i]*f(d-i, i)%MOD;
		}
		cout << ans << endl;
	}
	


	return 0;
}